<?php

include "session.php";
include "header.php"; // Incluir el menú
include "includes/functions.php";
include "config.php";

$id = $_GET["id"];
$slug = $_GET["slug"];
$ext = isset($_GET["ext"]) ? $_GET["ext"] : "mp4";
$logo_url = "assets/img/logo.png"; // URL del logo de tu sitio

$audio_tracks = []; // Inicializamos un array para las pistas de audio

// Lógica para películas y series
if ($slug == "movie") {
    $video_url = $get_dns . "/movie/" . $username . "/" . $password . "/" . $id . "." . $ext;
    $mime_type = "video/mp4";  // Tipo para películas (MP4)
    
    // Obtener el nombre real de la película y las pistas de audio
    $movie_info = getXtreamData('get_vod_info', ['vod_id' => $id]);
    $content_name = $movie_info['info']['name'];  // Nombre de la película
    $audio_tracks = $movie_info['info']['audio'];  // Obtener las pistas de audio
} elseif ($slug == "series") {
    $video_url = $get_dns . "/series/" . $username . "/" . $password . "/" . $id . "." . $ext;
    $mime_type = "video/mp4";  // Tipo para series (MP4)

    // Obtener el nombre de la serie y episodio, y las pistas de audio
    $series_info = getXtreamData('get_series_info', ['series_id' => $_GET['series_id']]);
    $content_name = $series_info['info']['name'];  // Nombre de la serie
    $audio_tracks = $series_info['info']['audio'];  // Obtener las pistas de audio
}

// Función para obtener datos desde Xtream Codes API
function getXtreamData($endpoint, $params = []) {
    global $get_dns, $username, $password;
    $url = $get_dns . "/player_api.php?username=" . $username . "&password=" . $password . "&action=" . $endpoint;
    if (!empty($params)) {
        $url .= '&' . http_build_query($params);
    }
    $response = file_get_contents($url);
    return json_decode($response, true);
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clappr Player - Multiple Audio Tracks</title>
    <script src="https://cdn.jsdelivr.net/npm/clappr@latest/dist/clappr.min.js"></script>

    <style>
        html, body {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
            background: #1c1c1c;
            font-family: 'Arial', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .video-player-container {
            width: 100%; /* Ocupa todo el ancho disponible */
            height: 100%; /* Ocupa todo el alto disponible */
            position: relative;
        }
        #player {
            width: 100%; /* Ancho del reproductor */
            height: 100%; /* Alto del reproductor */
        }
        .video-info {
            position: absolute;
            top: 10px;
            left: 20px;
            color: white;
            font-size: 24px;
            z-index: 2;
        }
        .video-info h2 {
            margin: 0;
        }
        .video-player-logo {
            position: absolute;
            top: 10px;
            right: 20px;
            width: 100px;
            z-index: 2;
        }
        .back_button {
            position: absolute;
            top: 10px;
            left: 10px;
            background: rgba(0, 0, 0, 0.7);
            padding: 10px;
            cursor: pointer;
            border-radius: 50%;
            text-decoration: none;
            color: white;
            font-size: 16px;
            z-index: 5;
            transition: background 0.3s ease;
        }
        .back_button:hover {
            background: rgba(255, 0, 0, 0.8);
        }
    </style>
</head>
<body>

    <div class="video-player-container">
        <a class="back_button" href=" 
            <?php if ($slug == 'movie') {
                echo 'Movie_description.php?id=' . $id;
            } elseif ($slug == 'series') {
                echo 'seriesvideo.php?id=' . $_GET['series_id'];
            } ?>">
            <i class="fa fa-arrow-left" aria-hidden="true"></i>
        </a>

        <div class="video-info">
            <h2><?php echo $content_name; ?></h2> <!-- Nombre del contenido -->
        </div>

        <img src="<?php echo $logo_url; ?>" class="video-player-logo" alt="Logo">

        <!-- Contenedor de Clappr -->
        <div id="player"></div>
    </div>

    <script>
        // Inicializar el reproductor Clappr
        var player = new Clappr.Player({
            source: "<?php echo $video_url; ?>",
            mimeType: "<?php echo $mime_type; ?>",
            parentId: "#player",
            autoPlay: true,
            mute: false,
            height: '100%',
            width: '100%',
        });

        // Esperar hasta que el reproductor esté listo
        player.on(Clappr.Events.PLAYER_READY, function() {
            console.log('Reproductor listo');

            // Verificar si hay múltiples pistas de audio
            var audioTracks = player.core.getCurrentContainer().playback.el.audioTracks;
            
            if (audioTracks && audioTracks.length > 1) {
                // Mostrar las pistas de audio en la consola
                for (let i = 0; i < audioTracks.length; i++) {
                    console.log('Pista de audio:', audioTracks[i].label || 'Pista ' + i, 'Idioma:', audioTracks[i].language);
                }
                
                // Cambiar a una pista específica
                // Por ejemplo, cambiar a la segunda pista de audio
                audioTracks[1].enabled = true;
            } else {
                console.log('No hay múltiples pistas de audio');
            }
        });
    </script>

</body>
</html>
